/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu;

import apicore.message.IPCEventLTV;
import apicore.message.LTV;
import apicore.message.LTVFactory;
import apicore.message.UUID;
import apicore.mu.MUConInMessage;
import apicore.mu.MUConOutMessage;
import apicore.mu.MULink;
import apicore.mu.MULinkUpdMessage;
import apicore.mu.MULinkUpdStatusMessage;
import apicore.mu.MUNameUpdMessage;
import apicore.mu.MUNegotiationMessage;
import apicore.mu.MUPDUMessage;
import apicore.mu.MUPortAdvMessage;
import apicore.mu.MUSaveNetReqMessage;
import apicore.mu.MUSaveNetRespMessage;
import apicore.mu.MuEventManager;
import apicore.mu.MuSessionState;
import apicore.mu.MultiUserMessage;
import apicore.ptmp.AuthenticationTask;
import apicore.ptmp.ConnectionNegotiationProperties;
import apicore.ptmp.ConnectionNegotiationTask;
import apicore.ptmp.DisconnectTask;
import apicore.ptmp.EventManager;
import apicore.ptmp.KeepAliveTask;
import apicore.ptmp.PacketTracerConnection;
import apicore.ptmp.PacketTracerReadWorker;
import apicore.ptmp.PacketTracerSession;
import apicore.ptmp.Pipeline;
import apicore.ptmp.SimpleEventManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class MUSession
extends PacketTracerSession {
    private PacketTracerConnection packetTracerConnection;
    private Pipeline pipeline;
    private PacketTracerReadWorker readWorker;
    private EventManager eventManager;
    private Timer timer;
    private long sessionID;
    protected boolean isShutdown = false;
    protected int readErrorCount = 0;
    protected MuSessionState mustate = MuSessionState.STATE_DISCONNECTED;
    protected String localNetwork = "Bridge";
    protected String remoteUsername;
    protected String remoteNetwork;
    protected UUID remoteUUID;
    protected MuEventManager muEventManager;
    protected ArrayList<MULink> links = new ArrayList();
    protected LTVFactory ltvFactory;

    public MUSession(String string, int n, ConnectionNegotiationProperties connectionNegotiationProperties) throws Exception {
        this.sessionID = System.nanoTime();
        this.ltvFactory = new LTVFactory();
        this.packetTracerConnection = new PacketTracerConnection(string, n, connectionNegotiationProperties);
        if (!this.packetTracerConnection.connect()) {
            throw new Error("Unable to connect to Packet Tracer", this.packetTracerConnection.getCurrentStatusThrowable());
        }
        MuSessionState muSessionState = this.mustate;
        this.mustate = MuSessionState.STATE_NEGOTIATING;
        if (this.muEventManager != null) {
            this.muEventManager.handleSessionStatusChanged(muSessionState, this.mustate);
        }
        ConnectionNegotiationTask connectionNegotiationTask = new ConnectionNegotiationTask(this.packetTracerConnection);
        connectionNegotiationTask.negotiateConnection();
        this.packetTracerConnection.connectLowLevelReadThread();
        this.pipeline = new Pipeline(this.ltvFactory, this.packetTracerConnection);
        AuthenticationTask authenticationTask = new AuthenticationTask(this);
        boolean bl = authenticationTask.authenticate();
        if (bl) {
            this.timer = new Timer(Long.toString(this.sessionID));
            KeepAliveTask keepAliveTask = new KeepAliveTask(this);
            this.timer.schedule((TimerTask)keepAliveTask, KeepAliveTask.KEEP_ALIVE_INTERVAL, (long)KeepAliveTask.KEEP_ALIVE_INTERVAL);
            this.eventManager = new SimpleEventManager(this);
            this.readWorker = new PacketTracerReadWorker(this, this.pipeline);
            this.muEventManager = null;
            MUNegotiationMessage mUNegotiationMessage = new MUNegotiationMessage("Bridge", UUID.makeRandom());
            this.readWorker.start();
            this.eventManager.start();
            this.write(mUNegotiationMessage);
        } else {
            System.out.println("Closing");
            this.close();
        }
    }

    public void registerEventManager(MuEventManager muEventManager) {
        this.muEventManager = muEventManager;
    }

    public void close() throws IOException {
        if (this.readWorker != null) {
            this.readWorker.shouldStop();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        DisconnectTask disconnectTask = new DisconnectTask(this);
        disconnectTask.disconnect();
        MuSessionState muSessionState = this.mustate;
        this.mustate = MuSessionState.STATE_DISCONNECTED;
        if (this.muEventManager != null) {
            this.muEventManager.handleSessionStatusChanged(muSessionState, this.mustate);
        }
        this.isShutdown = true;
    }

    protected void emergencyShutdown() {
        block6: {
            try {
                this.isShutdown = true;
                if (this.readWorker != null) {
                    this.readWorker.shouldStop();
                }
                if (this.timer != null) {
                    this.timer.cancel();
                }
                if (this.packetTracerConnection != null) {
                    this.packetTracerConnection.disconnect();
                }
                MuSessionState muSessionState = this.mustate;
                this.mustate = MuSessionState.STATE_DISCONNECTED;
                if (this.muEventManager != null) {
                    this.muEventManager.handleSessionStatusChanged(muSessionState, this.mustate);
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)throwable;
            }
        }
    }

    public boolean readWorkerError(Throwable throwable) {
        ++this.readErrorCount;
        boolean bl = false;
        try {
            bl = this.packetTracerConnection.isOpen();
        }
        catch (Throwable throwable2) {
            System.out.println(throwable2);
            if (throwable2 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable2;
            }
            bl = false;
        }
        if (!bl || this.readErrorCount > 10) {
            this.readWorker.shouldStop();
            this.emergencyShutdown();
            return false;
        }
        return true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public PacketTracerConnection connection() {
        return this.packetTracerConnection;
    }

    public Pipeline pipeline() {
        return this.pipeline;
    }

    public Timer timer() {
        return this.timer;
    }

    public boolean isConnected() {
        return this.packetTracerConnection.isConnected();
    }

    public void write(LTV lTV) throws IOException {
        this.pipeline.write(lTV);
    }

    public LTV writeRead(LTV lTV) throws IOException {
        if (lTV.hasResponse()) {
            if (this.readWorker == null) {
                throw new Error("Attempt to send an LTV with a non-blocking response before readWorker initialized; LTV = " + lTV);
            }
            this.readWorker.registerRequest(lTV);
            this.pipeline.write(lTV);
            return this.readWorker.getResponse(lTV);
        }
        if (this.readWorker != null) {
            throw new Error("Attempt to send an LTV with a blocking response after readWorker initialized; LTV = " + lTV);
        }
        this.pipeline.write(lTV);
        try {
            return this.pipeline.read();
        }
        catch (Exception exception) {
            throw new IOException("Pipeline read was interrupted");
        }
    }

    public void handleEvent(LTV lTV) {
        this.eventManager.processEvent((IPCEventLTV)lTV);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMuMessage(LTV lTV) {
        if (this.mustate == MuSessionState.STATE_NEGOTIATING) {
            if (lTV.getType() == 201) {
                try {
                    System.out.println("need someone to go to next step");
                    this.remoteUsername = ((MUNegotiationMessage)lTV).getUsername();
                    this.remoteUUID = ((MUNegotiationMessage)lTV).getUuid();
                    MuSessionState muSessionState = this.mustate;
                    this.mustate = MuSessionState.STATE_CONNECTED;
                    if (this.muEventManager != null) {
                        this.muEventManager.handleSessionStatusChanged(muSessionState, this.mustate);
                    }
                    MUNameUpdMessage mUNameUpdMessage = new MUNameUpdMessage(this.localNetwork);
                    this.write(mUNameUpdMessage);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            } else {
                if (lTV.getType() != 200) return;
                System.out.println("need someone to respond to a mu request");
            }
            return;
        } else {
            if (this.mustate != MuSessionState.STATE_CONNECTED) return;
            if (lTV.getType() == MultiUserMessage.PTMP_TYPE_MUPORTADV) {
                MUPortAdvMessage mUPortAdvMessage = (MUPortAdvMessage)lTV;
                if (this.muEventManager == null) return;
                this.muEventManager.handlePortAdvertisement(mUPortAdvMessage);
                return;
            } else if (lTV.getType() == MultiUserMessage.PTMP_TYPE_MULINKUPDATE) {
                MULinkUpdMessage mULinkUpdMessage = (MULinkUpdMessage)lTV;
                this.handleLinkUpdate(mULinkUpdMessage);
                return;
            } else if (lTV.getType() == MultiUserMessage.PTMP_TYPE_MULINKUPDATESTATUS) {
                MULinkUpdStatusMessage mULinkUpdStatusMessage = (MULinkUpdStatusMessage)lTV;
                if (this.muEventManager == null) return;
                this.muEventManager.handleLinkUpdateStatus(mULinkUpdStatusMessage);
                return;
            } else if (lTV.getType() == MultiUserMessage.PTMP_TYPE_MUPDU) {
                MUPDUMessage mUPDUMessage = (MUPDUMessage)lTV;
                if (this.muEventManager == null) return;
                this.muEventManager.handlePdu(mUPDUMessage);
                return;
            } else if (lTV.getType() == MultiUserMessage.PTMP_TYPE_MUSAVENETREQ) {
                MUSaveNetReqMessage mUSaveNetReqMessage = (MUSaveNetReqMessage)lTV;
                if (this.muEventManager == null) return;
                this.muEventManager.handleSaveNetworkRequest(mUSaveNetReqMessage);
                return;
            } else if (lTV.getType() == MultiUserMessage.PTMP_TYPE_MUSAVENETRESP) {
                MUSaveNetRespMessage mUSaveNetRespMessage = (MUSaveNetRespMessage)lTV;
                if (this.muEventManager == null) return;
                this.muEventManager.handleSaveNetworkResponse(mUSaveNetRespMessage);
                return;
            } else if (lTV.getType() == MultiUserMessage.PTMP_TYPE_MUCONIN) {
                MUConInMessage mUConInMessage = (MUConInMessage)lTV;
                if (this.muEventManager == null) return;
                this.muEventManager.handleIncomingConnection(mUConInMessage);
                return;
            } else if (lTV.getType() == MultiUserMessage.PTMP_TYPE_MUCONOUT) {
                MUConOutMessage mUConOutMessage = (MUConOutMessage)lTV;
                if (this.muEventManager == null) return;
                this.muEventManager.handleOutgoingConnection(mUConOutMessage);
                return;
            } else {
                if (lTV.getType() != MultiUserMessage.PTMP_TYPE_MUNAMEUPDATE) return;
                MUNameUpdMessage mUNameUpdMessage = (MUNameUpdMessage)lTV;
                this.remoteNetwork = mUNameUpdMessage.getName();
                if (this.muEventManager == null) return;
                this.muEventManager.handleNameUpdate(mUNameUpdMessage);
            }
        }
    }

    public void addLink(MULink mULink) throws Exception {
        mULink.linkId = this.links.size();
        mULink.linkUuid = UUID.makeRandom();
        MULinkUpdMessage mULinkUpdMessage = new MULinkUpdMessage();
        mULinkUpdMessage.linkOpId = 0;
        mULinkUpdMessage.opType = MULinkUpdMessage.OP_MAKE;
        mULinkUpdMessage.linkId = mULink.linkId;
        mULinkUpdMessage.linkUuid = mULink.linkUuid;
        mULinkUpdMessage.portId = mULink.localPortId;
        mULinkUpdMessage.cableType = mULink.localCableType;
        mULinkUpdMessage.portName = mULink.localPortName;
        mULinkUpdMessage.portType = mULink.localPortType;
        mULinkUpdMessage.portPower = mULink.localPortPower;
        mULinkUpdMessage.straightPins = mULink.localStraightPins;
        mULinkUpdMessage.autoCross = mULink.localAutoCross;
        mULinkUpdMessage.bandwidth = mULink.localBandwidth;
        mULinkUpdMessage.fullDuplex = mULink.localFullDuplex;
        mULinkUpdMessage.autoNegotiate = mULink.localAutoNego;
        mULinkUpdMessage.bandwidthAutoNegotiate = mULink.localBWNego;
        mULinkUpdMessage.duplexAutoNegotiate = mULink.localDuplexNego;
        mULinkUpdMessage.clockRate = mULink.localClockRate;
        mULinkUpdMessage.dcePort = mULink.localDcePort;
        mULinkUpdMessage.defaultPowerInline = mULink.localdefaultPowerInline;
        mULinkUpdMessage.powerInline = mULink.localpowerInline;
        mULinkUpdMessage.RequirePowerInline = mULink.localRequirePowerInline;
        mULinkUpdMessage.ProvidingPowerInline = mULink.localProvidingPowerInline;
        mULinkUpdMessage.DevicePower = mULink.localDevicePower;
        this.links.add(mULink);
        this.write(mULinkUpdMessage);
    }

    public void removeLink(MULink mULink) throws Exception {
        MULinkUpdMessage mULinkUpdMessage = new MULinkUpdMessage();
        mULinkUpdMessage.linkOpId = 0;
        mULinkUpdMessage.opType = MULinkUpdMessage.OP_DISCONNECT;
        mULinkUpdMessage.linkId = mULink.linkId;
        mULinkUpdMessage.linkUuid = mULink.linkUuid;
        mULinkUpdMessage.portId = mULink.localPortId;
        mULinkUpdMessage.cableType = mULink.localCableType;
        mULinkUpdMessage.portName = mULink.localPortName;
        mULinkUpdMessage.portType = mULink.localPortType;
        mULinkUpdMessage.portPower = mULink.localPortPower;
        mULinkUpdMessage.straightPins = mULink.localStraightPins;
        mULinkUpdMessage.autoCross = mULink.localAutoCross;
        mULinkUpdMessage.bandwidth = mULink.localBandwidth;
        mULinkUpdMessage.fullDuplex = mULink.localFullDuplex;
        mULinkUpdMessage.autoNegotiate = mULink.localAutoNego;
        mULinkUpdMessage.bandwidthAutoNegotiate = mULink.localBWNego;
        mULinkUpdMessage.duplexAutoNegotiate = mULink.localDuplexNego;
        mULinkUpdMessage.clockRate = mULink.localClockRate;
        mULinkUpdMessage.dcePort = mULink.localDcePort;
        mULinkUpdMessage.defaultPowerInline = mULink.localdefaultPowerInline;
        mULinkUpdMessage.powerInline = mULink.localpowerInline;
        mULinkUpdMessage.RequirePowerInline = mULink.localRequirePowerInline;
        mULinkUpdMessage.ProvidingPowerInline = mULink.localProvidingPowerInline;
        mULinkUpdMessage.DevicePower = mULink.localDevicePower;
        this.write(mULinkUpdMessage);
    }

    public void updateLink(MULink mULink) throws Exception {
        MULinkUpdMessage mULinkUpdMessage = new MULinkUpdMessage();
        mULinkUpdMessage.linkOpId = 0;
        mULinkUpdMessage.opType = MULinkUpdMessage.OP_UPDATE;
        mULinkUpdMessage.linkId = mULink.linkId;
        mULinkUpdMessage.linkUuid = mULink.linkUuid;
        mULinkUpdMessage.portId = mULink.localPortId;
        mULinkUpdMessage.cableType = mULink.localCableType;
        mULinkUpdMessage.portName = mULink.localPortName;
        mULinkUpdMessage.portType = mULink.localPortType;
        mULinkUpdMessage.portPower = mULink.localPortPower;
        mULinkUpdMessage.straightPins = mULink.localStraightPins;
        mULinkUpdMessage.autoCross = mULink.localAutoCross;
        mULinkUpdMessage.bandwidth = mULink.localBandwidth;
        mULinkUpdMessage.fullDuplex = mULink.localFullDuplex;
        mULinkUpdMessage.autoNegotiate = mULink.localAutoNego;
        mULinkUpdMessage.bandwidthAutoNegotiate = mULink.localBWNego;
        mULinkUpdMessage.duplexAutoNegotiate = mULink.localDuplexNego;
        mULinkUpdMessage.clockRate = mULink.localClockRate;
        mULinkUpdMessage.dcePort = mULink.localDcePort;
        mULinkUpdMessage.defaultPowerInline = mULink.localdefaultPowerInline;
        mULinkUpdMessage.powerInline = mULink.localpowerInline;
        mULinkUpdMessage.RequirePowerInline = mULink.localRequirePowerInline;
        mULinkUpdMessage.ProvidingPowerInline = mULink.localProvidingPowerInline;
        mULinkUpdMessage.DevicePower = mULink.localDevicePower;
        this.links.add(mULink);
        this.write(mULinkUpdMessage);
    }

    protected void handleLinkUpdate(MULinkUpdMessage mULinkUpdMessage) {
        UUID uUID = mULinkUpdMessage.linkUuid;
        if (mULinkUpdMessage.opType == MULinkUpdMessage.OP_MAKE) {
            MULink mULink = null;
            boolean bl = true;
            for (int i = 0; i < this.links.size(); ++i) {
                if (!this.links.get((int)i).linkUuid.equals(uUID)) continue;
                mULink = this.links.get(i);
                bl = false;
                break;
            }
            if (mULink == null || bl) {
                mULink = new MULink();
            }
            mULink.linkId = mULinkUpdMessage.linkId;
            mULink.linkUuid = uUID;
            mULink.remotePortId = mULinkUpdMessage.portId;
            mULink.remoteCableType = mULinkUpdMessage.cableType;
            mULink.remotePortName = mULinkUpdMessage.portName;
            mULink.remotePortType = mULinkUpdMessage.portType;
            mULink.remotePortPower = mULinkUpdMessage.portPower;
            mULink.remoteStraightPins = mULinkUpdMessage.straightPins;
            mULink.remoteAutoCross = mULinkUpdMessage.autoCross;
            mULink.remoteBandwidth = mULinkUpdMessage.bandwidth;
            mULink.remoteFullDuplex = mULinkUpdMessage.fullDuplex;
            mULink.remoteAutoNego = mULinkUpdMessage.autoNegotiate;
            mULink.remoteBWNego = mULinkUpdMessage.bandwidthAutoNegotiate;
            mULink.remoteDuplexNego = mULinkUpdMessage.duplexAutoNegotiate;
            mULink.remoteClockRate = mULinkUpdMessage.clockRate;
            mULink.remoteDcePort = mULinkUpdMessage.dcePort;
            mULink.remotedefaultPowerInline = mULinkUpdMessage.defaultPowerInline;
            mULink.remotepowerInline = mULinkUpdMessage.powerInline;
            mULink.remoteRequirePowerInline = mULinkUpdMessage.RequirePowerInline;
            mULink.remoteProvidingPowerInline = mULinkUpdMessage.ProvidingPowerInline;
            mULink.remoteDevicePower = mULinkUpdMessage.DevicePower;
            this.links.add(mULink);
            if (this.muEventManager != null) {
                this.muEventManager.handleLinkUpdate(mULink, bl ? MULinkUpdMessage.OP_MAKE : MULinkUpdMessage.OP_UPDATE);
            }
        } else {
            int n;
            MULink mULink = null;
            for (n = 0; n < this.links.size(); ++n) {
                if (!this.links.get((int)n).linkUuid.equals(uUID)) continue;
                mULink = this.links.get(n);
                break;
            }
            if (mULink == null) {
                return;
            }
            if (mULinkUpdMessage.opType == MULinkUpdMessage.OP_UPDATE) {
                mULink.remotePortId = mULinkUpdMessage.portId;
                mULink.remoteCableType = mULinkUpdMessage.cableType;
                mULink.remotePortName = mULinkUpdMessage.portName;
                mULink.remotePortType = mULinkUpdMessage.portType;
                mULink.remotePortPower = mULinkUpdMessage.portPower;
                mULink.remoteStraightPins = mULinkUpdMessage.straightPins;
                mULink.remoteAutoCross = mULinkUpdMessage.autoCross;
                mULink.remoteBandwidth = mULinkUpdMessage.bandwidth;
                mULink.remoteFullDuplex = mULinkUpdMessage.fullDuplex;
                mULink.remoteAutoNego = mULinkUpdMessage.autoNegotiate;
                mULink.remoteBWNego = mULinkUpdMessage.bandwidthAutoNegotiate;
                mULink.remoteDuplexNego = mULinkUpdMessage.duplexAutoNegotiate;
                mULink.remoteClockRate = mULinkUpdMessage.clockRate;
                mULink.remoteDcePort = mULinkUpdMessage.dcePort;
                mULink.remotedefaultPowerInline = mULinkUpdMessage.defaultPowerInline;
                mULink.remotepowerInline = mULinkUpdMessage.powerInline;
                mULink.remoteRequirePowerInline = mULinkUpdMessage.RequirePowerInline;
                mULink.remoteProvidingPowerInline = mULinkUpdMessage.ProvidingPowerInline;
                mULink.remoteDevicePower = mULinkUpdMessage.DevicePower;
                if (this.muEventManager != null) {
                    this.muEventManager.handleLinkUpdate(mULink, MULinkUpdMessage.OP_UPDATE);
                }
            } else if (mULinkUpdMessage.opType == MULinkUpdMessage.OP_DISCONNECT) {
                if (this.muEventManager != null) {
                    this.muEventManager.handleLinkUpdate(mULink, MULinkUpdMessage.OP_DISCONNECT);
                }
                mULinkUpdMessage.opType = MULinkUpdMessage.OP_DELETE;
                try {
                    this.write(mULinkUpdMessage);
                }
                catch (Exception exception) {
                    System.out.println("MU Link Update exception ");
                    exception.printStackTrace();
                }
            } else if (mULinkUpdMessage.opType == MULinkUpdMessage.OP_DELETE) {
                for (n = 0; n < this.links.size(); ++n) {
                    if (this.links.get(n) != mULink) continue;
                    this.links.remove(n);
                    if (this.muEventManager != null) {
                        this.muEventManager.handleLinkUpdate(mULink, MULinkUpdMessage.OP_DELETE);
                    }
                    return;
                }
            }
        }
    }
}

